--this script cointains the settings for creating a dialog with the global standard inposed on the game.
module('g_dialog', package.seeall);

local fade_in_delay = 0.5
local fade_out_delay = 0.5
local text_delay = 0.0

local last_type = -1
local participant_list = {}

function new(blayer, tlayer) --background layer, text layer
    lua:new_dialog(blayer,tlayer,fade_in_delay,fade_out_delay,text_delay) --background layer, text layer, fade in delay, fade out delay, text delay
end

function add_participant(id,bubble_x,bubble_y,x,y)
    participant_list[id] = {x,y,bubble_x,bubble_y}
end

function create_frame(participant, type, id, next_id, life) -- type, id, next_id
    if life == nil then
        life = 1
    elseif next_id == nil then
        next_id = 0
    end
    lua:new_frame(id,next_id) --frame id, next frame
    last_type = type
    lua:set_line_settings_1(type,H_CENTER,V_BOTTOM,H_CENTER,"font") --type, horizontal mode, vertical mode, line aligment(LINE only), font
    lua:set_line_settings_2(type,8.0,0.0,2.0,32.0,6.0,1.0) --type, border, padding, line_spacing, text_height, text spacing, text_width_factor
    
    local par = participant_list[participant]
    lua:new_line(type,par[1],par[2],par[3],par[4],life) --type, x, y, source x, source y, life (LINE only)
end

--adds a watcher to frame, eg. if goes to that frame calls some script..
function add_watcher(script) --script name
    lua:frame_add_script(script)
end

function add_line(text) --text
    if last_type ~= LINE then 
        return
    end    
    lua:add_line_text(text) --text    
end

function add_option(text,next_id) --text, next id
    if last_type ~= QUESTION then
        return
    end
    lua:add_question_option(text, next_id) --text,option
end

function upload()
    if last_type == QUESTION then 
        lua:upload_question()    
    elseif last_type == LINE then
        lua:upload_line()    
    else
        return
    end
    
    lua:upload_frame()
    last_type = -1
end

function reset()
    last_type = -1
    participant_list = {}
end

